<?php

// myaddrdir_functions.php3
// Common functions go here

function GenerateHTMLHeader($message) {
   printf ("<HEAD> <title> Address Directory on the Web </title> </HEAD>");
   printf("<bODY TEXT=\"#000000\" BGCOLOR=\"#999999\" LINK=\"#0000EE\"VLINK=\"#551A8B\" ALINK=\"#FF0000\">\n");
   printf("<H1><FONT SIZE=+4 >My Address Directory</FONT></H1><BR><BR>");
   printf("<TABLE CELLPADDING=4 CELLSPACING=0 BORDER=0 WIDTH=600>");
   printf("<TR BGCOLOR=\"#dcdcdc\"><TD><FONT FACE=Arial><B>");
   printf("%s</B></FONT><BR></TD>", $message);
   printf("<TD ALIGN=right>");
   printf("</FONT></TD></TR>");
   printf("</TABLE>");
   printf("<BR>");
   printf("<BR>");
}

function GenerateFrontPage() {
   printf("<form method=post action=myaddrdir_first.php3>");
   printf("<INPUT TYPE=\"submit\" NAME=\"choice\" VALUE=\"SEARCH DIRECTORY\">");
   printf("&nbsp; &nbsp; &nbsp;");
   printf("<INPUT TYPE=\"submit\" NAME=\"choice\" VALUE=\"ADD A NEW ENTRY\">");
   printf("<BR>");
   printf("<BR>");
   printf("<ul>");
   printf("<li> Search entries in the Directory by clicking <i>Search Directory</i></li>");
   printf("<li> Add entries to the Directory by clicking <i>Add a new Entry</i></li>");
   printf("<li> Modify an existing entry by clicking <i>Search Directory</i> first and then choosing the entry to Modify</li>");
   printf("<li> Delete an existing entry by clicking <i>Search Directory</i> first and then choosing the entry to Delete</li>");
   printf("</FORM>");
}

function DisplayErrMsg($message) {
   printf("<bLOCKQUOTE><bLOCKQUOTE><bLOCKQUOTE><H3><FONT COLOR=\"#cc0000\">%s</FONT></H3></BLOCKQUOTE></BLOCKQUOTE></BLOCKQUOTE>\n", $message);
}

function ConnectBindServer($bindRDN = 0, $bindPassword = "") {

   global $ldapServer;
   global $ldapServerPort;
   $linkIdentifier = ldap_connect($ldapServer, $ldapServerPort);

   if ($linkIdentifier) {
      if (!ldap_bind($linkIdentifier, $bindRDN, $bindPassword)) {
         DisplayErrMsg("Unable to bind to LDAP server !!");
      return 0;
      }
   } else {
      DisplayErrMsg("Unable to connect to the LDAP server !!");
      return 0;
   }

   return $linkIdentifier;
}

function CreateSearchFilter($searchCriteria) {
   $noOfFieldsSet = 0;

   if ($searchCriteria["cn"]) {
      $searchFilter = "(cn=*" . $searchCriteria["cn"] . "*)";
      ++$noOfFieldsSet;
   }

   if ($searchCriteria["mail"]) {
      $searchFilter = $searchFilter . "(mail=*" . $searchCriteria["mail"] . "*)";
      ++$noOfFieldsSet;
   }

   if ($searchCriteria["locality"]) {
      $searchFilter = $searchFilter . "(locality=*" . $searchCriteria["locality"] . "*)";
      ++$noOfFieldsSet;
   }
   
   if ($searchCriteria["description"]) {
      $searchFilter = $searchFilter . "(description=*" . $searchCriteria["description"] . "*)";
      ++$noOfFieldsSet;
   }
  
   if ($searchCriteria["telephonenumber"]) {
      $searchFilter = $searchFilter . "(telephonenumber=*" . $searchCriteria["telephonenumber"] . "*)";
      ++$noOfFieldsSet;
   }
  
   if ($noOfFieldsSet >= 2) {
      $searchFilter = "(&" .$searchFilter. ")";
   }

   return $searchFilter;
}

function SearchDirectory($linkIdentifier, $searchFilter) {

   global $baseDN;
   $searchResult = ldap_search($linkIdentifier, $baseDN, $searchFilter);

   if (ldap_count_entries($linkIdentifier, $searchResult) <= 0) {
      DisplayErrMsg("No entries returned from the directory");
   return 0;
   } else {
      $resultEntries = ldap_get_entries($linkIdentifier, $searchResult);
   return $resultEntries;
   }
}

function PrintResults($resultEntries) {
   printf("<TABLE BORDER WIDTH=\"100%%\" BGCOLOR=\"#dcdcdc\" NOSAVE>\n");
   printf("<TR><TD><B>Name</B></TD><TD><B>E-mail</B></TD><TD><B>City</B></TD><TD><B>Description</B></TD><TD><B>Telephone</B></TD><TD><B>Modify/Delete</B></TD></TR></B>\n");

   $noOfEntries = $resultEntries["count"];

   for ($i = 0; $i < $noOfEntries; $i++) {
      $urlString = urlencode($resultEntries[$i]["mail"][0]);
      printf("<TR><TD>%s</TD><TD>%s</TD><TD>%s</TD><TD>%s</TD><TD>%s</TD><TD><A HREF=\"myaddrdir_modify.php3?mail=%s&firstCall=1\"><i>Modify</i></A>/<A HREF=\"myaddrdir_delete.php3?mail=%s\"><i>Delete</i></A><TD></TR>\n",
          $resultEntries[$i]["cn"][0],
          $resultEntries[$i]["mail"][0],  
          $resultEntries[$i]["locality"][0], 
          $resultEntries[$i]["description"][0], 
          $resultEntries[$i]["telephonenumber"][0],
          $urlString, 
          $urlString);
      }
   printf("</table>\n");
}

function GenerateHTMLForm($formValues, $actionScript, $submitLabel) {
   printf("<FORM METHOD=post ACTION=\"%s\"><PRE>\n", $actionScript);
   printf("Name:        <INPUT TYPE=text SIZE=35 NAME=cn VALUE=\"%s\"><BR>\n",$formValues) ? $formValues[0]["cn"][0] : "");

   printf("E-mail:      <INPUT TYPE=text SIZE=35 NAME=mail VALUE=\"%s\"><BR>\n",($formValues) ? $formValues[0]["mail"][0] : "");
   printf("City:        <INPUT TYPE=text SIZE=35 NAME=locality VALUE=\"%s\"><BR>\n",($formValues) ? $formValues[0]["locality"][0] : "");
   printf("Description: <INPUT TYPE=text SIZE=35 NAME=description VALUE=\"%s\"><BR>\n",($formValues) ? $formValues[0]["description"][0] : "");
   printf("Telephone:   <INPUT TYPE=text SIZE=35 NAME=telephonenumber VALUE=\"%s\"><BR>\n", ($formValues) ? $formValues[0]["telephonenumber"][0] : "");
   printf("             <INPUT TYPE=submit VALUE=\"%s\">", $submitLabel);
   printf("</PRE></FORM>");
}

function ReturnToMain() {
   printf("<BR><FORM ACTION=\"myaddrdir_first.php3\" METHOD=post>\n");
   printf("<INPUT TYPE=submit VALUE=\"Click\"> to return to Main Page\n");
}

function CloseConnection($linkIdentifier) {
   ldap_close($linkIdentifier);
}
?>
